/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.FakeLightingProvider;
import fi.dy.masa.litematica.world.WorldSchematic;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class ChunkManagerSchematic
extends ChunkSource {
    private final WorldSchematic world;
    private final Long2ObjectMap<ChunkSchematic> loadedChunks = new Long2ObjectOpenHashMap(8192);
    private final ChunkSchematic blankChunk;
    private final LevelLightEngine lightingProvider;
    private final FakeLightingProvider fakeLightingProvider;

    public ChunkManagerSchematic(WorldSchematic world) {
        this.world = world;
        this.blankChunk = new ChunkSchematic(world, new ChunkPos(0, 0));
        this.lightingProvider = new LevelLightEngine((LightChunkGetter)this, true, world.dimensionType().hasSkyLight());
        this.fakeLightingProvider = new FakeLightingProvider((LightChunkGetter)this);
    }

    @Nonnull
    public WorldSchematic getWorld() {
        return this.world;
    }

    public void loadChunk(int chunkX, int chunkZ) {
        ChunkSchematic chunk = new ChunkSchematic(this.world, new ChunkPos(chunkX, chunkZ));
        this.loadedChunks.put(ChunkPos.asLong((int)chunkX, (int)chunkZ), (Object)chunk);
    }

    public boolean hasChunk(int chunkX, int chunkZ) {
        return this.loadedChunks.containsKey(ChunkPos.asLong((int)chunkX, (int)chunkZ));
    }

    @Nonnull
    public String gatherStats() {
        return "Schematic Chunk Cache: " + this.getLoadedChunksCount();
    }

    public int getLoadedChunksCount() {
        return this.loadedChunks.size();
    }

    public Long2ObjectMap<ChunkSchematic> getLoadedChunks() {
        return this.loadedChunks;
    }

    public LevelChunk getChunk(int chunkX, int chunkZ, @Nonnull ChunkStatus status, boolean fallbackToEmpty) {
        ChunkSchematic chunk = this.getChunk(chunkX, chunkZ);
        return chunk == null && fallbackToEmpty ? this.blankChunk : chunk;
    }

    public ChunkSchematic getChunk(int chunkX, int chunkZ) {
        ChunkSchematic chunk = (ChunkSchematic)((Object)this.loadedChunks.get(ChunkPos.asLong((int)chunkX, (int)chunkZ)));
        return chunk == null ? this.blankChunk : chunk;
    }

    @Nullable
    public ChunkSchematic getChunkIfExists(int chunkX, int chunkZ) {
        return (ChunkSchematic)((Object)this.loadedChunks.get(ChunkPos.asLong((int)chunkX, (int)chunkZ)));
    }

    public void unloadChunk(int chunkX, int chunkZ) {
        ChunkSchematic chunk = (ChunkSchematic)((Object)this.loadedChunks.remove(ChunkPos.asLong((int)chunkX, (int)chunkZ)));
        if (chunk != null) {
            this.world.unloadedEntities(chunk.getEntityCount());
            this.world.unloadEntitiesByChunk(chunkX, chunkZ);
            chunk.clearEntities();
        }
    }

    @Nonnull
    public LevelLightEngine getLightEngine() {
        if (Configs.Visuals.ENABLE_SCHEMATIC_FAKE_LIGHTING.getBooleanValue()) {
            return this.fakeLightingProvider;
        }
        return this.lightingProvider;
    }

    public void tick(@Nonnull BooleanSupplier shouldKeepTicking, boolean tickChunks) {
    }

    public int getTileEntityCount() {
        int count = 0;
        Iterator iter = this.loadedChunks.values().stream().iterator();
        while (iter.hasNext()) {
            count += ((ChunkSchematic)((Object)iter.next())).getTileEntityCount();
        }
        return count;
    }
}

